<?php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';

require_role(['super_admin']);
$user = current_user();

$page_title = 'Platform Admin Dashboard';
include __DIR__ . '/../includes/header.php';
?>

<section class="content">
    <div class="container-fluid">
        <h1 class="mb-4">Platform Admin Dashboard</h1>

        <div class="row">
            <div class="col-md-6">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">System Management</h3>
                    </div>
                    <div class="card-body">
                        <p>Welcome, <?= e($user['first_name'] . ' ' . $user['last_name']) ?>.</p>
                        <ul>
                            <li><a href="schools.php">Manage Schools</a></li>
                            <li><a href="global_settings.php">Global Settings (SMTP, etc.)</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

    </div>
</section>

<?php include __DIR__ . '/../includes/footer.php'; ?>
