<?php
declare(strict_types=1);

require_once __DIR__ . '/../includes/helpers.php';

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email    = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($email === '' || $password === '') {
        $errors[] = 'Email and password are required.';
    } else {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare('SELECT * FROM users WHERE email = :email AND is_active = 1 LIMIT 1');
        $stmt->execute(['email' => $email]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password_hash'])) {
            $_SESSION['user_id'] = $user['id'];

            $update = $pdo->prepare('UPDATE users SET last_login_at = NOW() WHERE id = :id');
            $update->execute(['id' => $user['id']]);

            if ($user['role'] === 'super_admin') {
                redirect('admin/index.php');
            } else {
                redirect('school/index.php');
            }
        } else {
            $errors[] = 'Invalid credentials.';
        }
    }
}

$adminlteBase = rtrim(BASE_URL, '/') . '/themes/AdminLTE';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login | Parents Evening System</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- AdminLTE CSS (local) -->
    <link rel="stylesheet" href="<?= e($adminlteBase) ?>/css/adminlte.min.css">

    <!-- Font Awesome (CDN) -->
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
          integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA=="
          crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>
<body class="hold-transition login-page">
<div class="login-box">
    <div class="login-logo">
        <b>Parents</b> Evening
    </div>
    <div class="card">
        <div class="card-body login-card-body">
            <p class="login-box-msg">Sign in to start your session</p>

            <?php if ($errors): ?>
                <div class="alert alert-danger">
                    <?php foreach ($errors as $error): ?>
                        <div><?= e($error) ?></div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <form action="" method="post">
                <div class="input-group mb-3">
                    <input type="email" name="email" class="form-control" placeholder="Email" required>
                    <div class="input-group-append">
                        <div class="input-group-text"><span class="fas fa-envelope"></span></div>
                    </div>
                </div>
                <div class="input-group mb-3">
                    <input type="password" name="password" class="form-control" placeholder="Password" required>
                    <div class="input-group-append">
                        <div class="input-group-text"><span class="fas fa-lock"></span></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-8">
                        <!-- Remember me toggle later if you want -->
                    </div>
                    <div class="col-4">
                        <button type="submit" class="btn btn-primary btn-block">Sign In</button>
                    </div>
                </div>
            </form>

        </div>
    </div>
</div>

<!-- jQuery (CDN) -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-3gJwYp4xkMtd/3O3SX6U02zsz5WcC4zZ2R3p3q2Q0yg="
        crossorigin="anonymous"></script>

<!-- Bootstrap 4 bundle (CDN) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-Fy6S3B9q64WdZWQUiU+q4/2LcCkFj6c5B3p6G7niu735Sk7lN0uVM1FAdnNQ9M6M"
        crossorigin="anonymous"></script>

<!-- AdminLTE JS (local) -->
<script src="<?= e($adminlteBase) ?>/js/adminlte.min.js"></script>
</body>
</html>
