<?php
declare(strict_types=1);

require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/helpers.php';

require_login();
$user = current_user();

if (!isset($page_title)) {
    $page_title = 'Parents Evening System';
}

$adminlteBase = rtrim(BASE_URL, '/') . '/themes/AdminLTE';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= e($page_title) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- AdminLTE CSS (local) -->
    <link rel="stylesheet" href="<?= e($adminlteBase) ?>/css/adminlte.min.css">

    <!-- Font Awesome (CDN) -->
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
          integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA=="
          crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>
<body class="hold-transition sidebar-mini">
<div class="wrapper">

    <!-- Navbar -->
    <nav class="main-header navbar navbar-expand navbar-white navbar-light">
        <!-- Left navbar links -->
        <ul class="navbar-nav">
            <?php if (is_super_admin()): ?>
                <li class="nav-item">
                    <a href="<?= e(BASE_URL) ?>/admin/index.php" class="nav-link">
                        <i class="fas fa-tools"></i> Admin
                    </a>
                </li>
            <?php endif; ?>

            <li class="nav-item">
                <a href="<?= e(BASE_URL) ?>/school/index.php" class="nav-link">
                    <i class="fas fa-home"></i> Dashboard
                </a>
            </li>
        </ul>

        <!-- Right navbar links -->
        <ul class="navbar-nav ml-auto">
            <li class="nav-item">
                <span class="nav-link">
                    <i class="fas fa-user"></i>
                    <?= e($user['first_name'] . ' ' . $user['last_name']) ?>
                    (<?= e($user['role']) ?>)
                </span>
            </li>
            <li class="nav-item">
                <a href="<?= e(BASE_URL) ?>/auth/logout.php" class="nav-link">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </li>
        </ul>
    </nav>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper p-3">
