<?php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';

require_login();
$user = current_user();

switch ($user['role']) {
    case 'school_admin':
        require __DIR__ . '/dashboard_school_admin.php';
        break;
    case 'teacher':
        require __DIR__ . '/dashboard_teacher.php';
        break;
    case 'parent':
        require __DIR__ . '/dashboard_parent.php';
        break;
    default:
        // Shouldn’t really arrive here
        echo 'Invalid role.';
}
